/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.List;
import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.assessment.PantherMediaObject;
import pse.assessment.PantherTask;
import pse.util.general.LookupList;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PantherTasks
extends AssessmentObject {
    protected LookupList<String, PantherTask> tasks = new LookupList();
    protected LookupList<String, PantherMediaObject> mediaObjects = new LookupList();

    @Override
    public String getElementName() {
        return "panther-tasks";
    }

    @Override
    public boolean isTaskObject() {
        return true;
    }

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        for (AssessmentObject assessmentObject : this.mediaObjects) {
            ((PantherMediaObject)assessmentObject).checkForConsistency(consistencyChecker);
        }
        for (AssessmentObject assessmentObject : this.tasks) {
            ((PantherTask)assessmentObject).checkForConsistency(consistencyChecker);
        }
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.mediaObjects.size() > 0 || this.tasks.size() > 0;
    }

    public PantherMediaObject getFirstMediaObject() {
        return this.mediaObjects.get((String)false);
    }

    public PantherTask getFirstTask() {
        return this.tasks.get((String)false);
    }

    public PantherMediaObject getMediaObject(String string) {
        return this.mediaObjects.get(string);
    }

    public List<PantherMediaObject> getMediaObjects() {
        return this.mediaObjects.getList();
    }

    public PantherTask getTask(String string) {
        return this.tasks.get(string);
    }

    public List<PantherTask> getTasks() {
        return this.tasks.getList();
    }

    public void addMediaObject(PantherMediaObject pantherMediaObject) {
        this.mediaObjects.add(pantherMediaObject.getVdsIdent(), pantherMediaObject);
    }

    public void addTask(PantherTask pantherTask) {
        this.tasks.add(pantherTask.getVdsIdent(), pantherTask);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (AssessmentObject assessmentObject : this.mediaObjects) {
            this.addChild(xmlWriter, assessmentObject);
        }
        for (AssessmentObject assessmentObject : this.tasks) {
            this.addChild(xmlWriter, assessmentObject);
        }
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Node> list = XmlUtils.getNodeChildren(node, "panther-media-object");
        for (Node node2 : list) {
            this.addMediaObject((PantherMediaObject)this.readChildFromChildNode(node2, new PantherMediaObject()));
        }
        list = XmlUtils.getNodeChildren(node, "panther-task");
        for (Node node2 : list) {
            this.addTask((PantherTask)this.readChildFromChildNode(node2, new PantherTask()));
        }
    }
}

